/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	ProgressScene
**
** DESCRIPTION:	Progress scene with puzzles, statistics and achievements tabs
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef THE_PROGRESS_SCENE_H
#define THE_PROGRESS_SCENE_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwScene.h"
#include "ldwButton.h"
#include "ldwTextControl.h"
#include "../Achievements/Achievement.h"
#include "../Puzzles/Puzzle.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const ldwRect ProgressScene_c_iTabRect(78, 47, 78 + 641, 47 + 467);

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CProgressScene : public ldwScene
{
private:

	//class enumerations
	enum EButton
	{
		eButton_Done = 0,
		eButton_Puzzles,
		//eButton_Statistics,
		eButton_Achievements,
		eButton_Refresh,

		eButton_NumberOf
	};

	enum EStat
	{
		eStat_RealHoursPlayed = 0,
		eStat_PointsEarned,		
		eStat_BabiesMade,		
		eStat_FoodGathered,		
		eStat_VillagersCured,		
		eStat_ItemsFound,		
		eStat_MaxPopulation,			
		eStat_VillagersDied,			
		eStat_OldestVillager,	
		eStat_NumCrisis,			
		eStat_NumTwins,  
		eStat_NumTriplets,
		eStat_PuzzlesSolved,

		eStat_NumberOf
	};

	//class structures
	struct SStat
	{
		ldwTextControl *	m_pStatName;
		ldwTextControl *	m_pStatValue;
		ldwTextControl *	m_pRankName;
		ldwTextControl *	m_pRankValue;
	};

	struct SAchievement
	{
		ldwTextControl *	m_pName;
		ldwTextControl *	m_pDesc;
	};

	struct SPuzzleIcon
	{
		ldwPoint			m_sPos;
	};

	//class data
	static CProgressScene *	m_pInstance;
	ldwButton *				m_pButton[eButton_NumberOf];
	EButton					m_eCurrentSelection;
	ldwTextControl *		m_pTabLabel;
	SStat					m_sStat[eStat_NumberOf];
	SAchievement			m_sAchievement[eAchievement_NumberOf];
	SPuzzleIcon				m_sPuzzleIcon[ePuzzle_NumberOfEssential];

	int m_iRefreshStage;

	//class methods
	//setup
	private:	CProgressScene();
	private:	~CProgressScene();
	public:		static CProgressScene *Get();
	public:		static CProgressScene &Ref();
	public:		static void Destroy();

	//prevent copy
	public:		CProgressScene(const CProgressScene &);
	public:		CProgressScene & operator = (const CProgressScene &);

	//process
	protected:	void Activate(bool bIsActive);
	protected:	void UpdateScene();
	protected:	void DrawScene();
	protected:  void DrawSceneFinal();
	private:	void DrawPuzzleIcons(const bool bIsComplete) const;
	private:	void RefreshTab();
	private:	void RefreshGlobalStats();
	public:		bool HandleKey(int iMessageID, int iKeyCode, int iCharacter);
	public:		bool HandleMessage(int iMessageID, long iData);
	public:		bool HandleMouse(int iMessageID, ldwPoint sMousePos);

	//access
};

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/